<?php
namespace backend\controllers;

use backend\models\Admin;
use common\models\Setting;
use Yii;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\AdminLoginForm;

/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    [
                        'actions' => ['logout', 'index', 'error', 'proxylist'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {
        return $this->render('index');
    }

    /**
     * Login action.
     *
     * @return string
     */
    public function actionLogin()
    {
        
        $model = new AdminLoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            Yii::info('Admin '. Yii::$app->user->identity->login . ' logged in', $category = 'admininfo');
            return $this->goBack();
            //return $this->redirect(Yii::$app->params['backend'] . "/index.php");
        } else {
            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }


    /**
     * Logout action.
     *
     * @return string
     */
    public function actionLogout()
    {
        Yii::info('Admin '. Yii::$app->user->identity->login . ' logged out', $category = 'admininfo');
        
        Yii::$app->user->logout();
        return $this->goHome();
    }

    public function actionProxylist()
    {
        return $this->renderPartial('proxylist');
    }

    public function actionBotstatus()
    {
        return $this->renderPartial('botstat');
    }

    
}
